
#ifndef GLOBAL_CONTEXT_H
#define GLOBAL_CONTEXT_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_basetypes.h"
#include "CRYS.h"
#ifdef KMNG_ON_SEP
#include "LLF_KMNG.h"
#include "KMNG_DEFS.h"
#endif
#ifdef TLK_ODRM_ON_SEP
#include "tlk_odrm_llf_types.h"
#endif
#ifdef TLK_CERT_ON_SEP
#include "tlk_cert_internal_types.h"
#include "tlk_cert_ocsp_parser_types.h"
#endif
#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % FLOW_DB.h    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 16:42:30 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the enums and definitions for the flow database. 
   *
   *  \version flow_db.h#1:incl:13
   *  \author avis
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/


/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************ context Structs  ******************************/
typedef struct
{
	CRYS_RSAUserPrivKey_t UserPrivKey_ptr;
	CRYS_RSAUserPubKey_t  UserPubKey_ptr;
	CRYS_RSAKGData_t      KeyGenData_ptr;
}DX_SEP_PARSE_KG_CONTEXT_t;

typedef struct
{
	DxUint32_t		   res1[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t		   res2[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	CRYS_DHUserPubKey_t  pubKey;
	CRYS_DHPrimeData_t primeData;
}DX_SEP_PARSE_DH_BUFF_t;


typedef struct
{
	DxUint32_t				res[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	CRYS_RSAPrivUserContext_t	signCon; /* 4888 Bytes */
}DX_SEP_PARSE_SIGN_BUFF_t;

typedef struct
{
	DxUint32_t				res[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS*4];
	CRYS_ECDSA_SignUserContext_t EccSignCon;
}DX_SEP_PARSE_ECC_SIGN_BUFF_t;


typedef struct
{
	CRYS_ECPKI_UserPrivKey_t   UserPrivKey_ptr;
	CRYS_ECPKI_UserPublKey_t   UserPublKey_ptr;
	CRYS_ECPKI_KG_TempData_t   TempData_ptr;    
}DX_SEP_PARSE_ECC_KG_CONTEXT_t;

typedef struct
{
	DxUint32_t   E[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t   N[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t   D[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];    
}DX_SEP_PARSE_RSA_NON_CRT_EXPS_BUFF_t;

typedef struct
{
	DxUint32_t   P[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t   Q[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t   DP[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];   
	DxUint32_t   DQ[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];    
	DxUint32_t   QINV[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];    
}DX_SEP_PARSE_RSA_CRT_EXPS_BUFF_t;


typedef union 
{
	DX_SEP_PARSE_RSA_NON_CRT_EXPS_BUFF_t  nonCrt;
	DX_SEP_PARSE_RSA_CRT_EXPS_BUFF_t crt;
}DX_SEP_PARSE_RSA_EXPS_BUFF_t;

typedef struct
{
	DxUint32_t				res[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	CRYS_RSAPrimeData_t		primeData;
}DX_SEP_PARSE_RSA_ENC_DEC_RES_BUFF_t;

typedef struct
{
	CRYS_ECPKI_UserPublKey_t    UserPublKey;
	CRYS_ECPKI_BUILD_TempData_t TempBuff;
}DX_SEP_PARSE_ECC_BUILD_PUB_KEY_BUFF_t;

typedef struct
{
	DxUint32_t pubKey[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS*2];
}DX_SEP_PARSE_ECC_EXPORT_PUB_KEY_BUFF_t;

typedef struct
{
#ifndef DX_RENESAS_G3_V2
	DxUint32_t ElGamalRes[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS*4];
#endif
	CRYS_EC_ELGAMAL_TempData_t ElGamalTmbBuff;
}DX_SEP_PARSE_ECC_ELGAMAL_RES_BUFF_t;

typedef struct
{
	DxUint32_t ECDHRes[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS*4];
	CRYS_ECDH_TempData_t ECDHTempBuff;
}DX_SEP_PARSE_ECDH_RES_BUFF_t;

typedef struct
{
	DxUint32_t buff[1024];
}DX_SEP_PARSE_AES_WRAP_BUFF_t;

typedef struct
{
	DxUint32_t wrapCtr[32];
	DxUint32_t unWrapCtr[32];
}DX_SEP_PARSE_MTC_WRAP_BUFF_t;

typedef struct
{
	DxUint32_t buff[sizeof(CRYS_RSAUserPrivKey_t)/sizeof(DxUint32_t) + 4];
}DX_SEP_PARSE_PRIVATE_KEY_BUFF_t;

typedef struct
{
	DxUint32_t privKeyBuff[sizeof(CRYS_RSAUserPrivKey_t)/sizeof(DxUint32_t) + 4];
	CRYS_RSAUserPubKey_t  UserPubKey;
	CRYS_RSAKGData_t      KeyGenData;
}DX_SEP_PARSE_CA_KG_CONTEXT_t;

#ifdef KMNG_ON_SEP
typedef struct
{
	KMNG_BufferData_t		keyBufferData;
}DX_SEP_PARSE_USER_KEY_KMNG_BUFF_t;

typedef struct
{
	DxUint32_t				res[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	KMNG_RSA_WrappedKey_t	wrapKey;
	CRYS_RSAPrimeData_t		primeData;
}DX_SEP_PARSE_KMNG_RSA_KEY_t;
#endif
#ifdef SST_ON_SEP
typedef struct  
{
    DxByte_t                crysSSTRSAKeyAndPrimeBuff [sizeof(CRYS_SST_RSA_keys_and_data_container_t)];   /* 4712 bytes */
}DX_SEP_PARSE_CRYS_SST_RSA_BUFF_t;
#endif

#ifdef TLK_CERT_ON_SEP
typedef struct
{
    TLK_CERT_OCSPResponse_t parsedResponse;
    TLK_CERT_Cert_t         parsedResponderCert;
    TLK_CERT_Cert_t         certToBeChecked;
    TLK_CERT_Cert_t         parsedCertResponder;
    TLK_CERT_Cert_t         parsedCertCA;
}TLK_CERT_RESPONSE_PROCESS_BUFF_t;
#endif
typedef union
{
	/* context for the CRYS_AES */
	CRYS_AESUserContext_t					aesCon; /*180 bytes*/
#ifndef CRYS_NO_C2_SUPPORT
	CRYS_C2CipherUserContext_t				c2Con;
#endif

#ifndef CRYS_NO_AESCCM_SUPPORT
	CRYS_AESCCM_UserContext_t				aesccmCon; /*??? bytes*/
#endif
	CRYS_DESUserContext_t					desCon; /*68 bytes*/
	CRYS_HASHUserContext_t					hashCon;/*244 bytes*/
	CRYS_HMACUserContext_t					hmacCon;/*400 bytes*/
	CRYS_RC4UserContext_t					rc4Con;/*288 bytes*/
	CRYS_OTFUserContext_t					otfCon;
	CRYS_CMLA_KDF_TEMP_t					cmlaKDF;/*184 bytes */
	CRYS_CMLA_RSA_TempBuff_t				cmlaTmpBuff;/*1840 bytes*/
	DX_SEP_PARSE_KG_CONTEXT_t				kgBuff;/*4078 bytes*/
	CRYS_RSAUserPubKey_t					pubKey;/*808 bytes*/
	CRYS_RSAUserPrivKey_t					privKey; /*2156 bytes*/
	DX_SEP_PARSE_SIGN_BUFF_t				sign;/*5152 bytes */
	CRYS_RSAPubUserContext_t				verifyCon;/*3272 bytes */
	DX_SEP_PARSE_DH_BUFF_t					dhBuff;/*2920 bytes*/
	DX_SEP_PARSE_ECC_KG_CONTEXT_t			eccKgBuff;/*3132 bytes*/
	DX_SEP_PARSE_RSA_EXPS_BUFF_t			expBuff;/*1320 bytes*/
	DX_SEP_PARSE_RSA_ENC_DEC_RES_BUFF_t		resBuff; /*1848 bytes*/
	DX_SEP_PARSE_ECC_BUILD_PUB_KEY_BUFF_t	EccBuildPubKeyBuf;/*2528 bytes*/
	CRYS_ECPKI_UserPrivKey_t				EccPrivKey;/*84 bytes*/
	DX_SEP_PARSE_ECC_EXPORT_PUB_KEY_BUFF_t	EccExPublKey;/*144 bytes*/
	DX_SEP_PARSE_ECC_ELGAMAL_RES_BUFF_t		ElGamalBuff;/*5268 bytes*/
	DX_SEP_PARSE_ECDH_RES_BUFF_t			ECDHBuff;/*3104 bytes*/
	DX_SEP_PARSE_ECC_SIGN_BUFF_t			EccSign;/*3780 bytes*/
	CRYS_ECDSA_VerifyUserContext_t			EccVerifyCon;/*3780 bytes*/
	DX_SEP_PARSE_AES_WRAP_BUFF_t			aesWrapBuff;/*0x1000*/
	CRYS_SelfTestData_t						TempData_ptr;/*0x868*/
	DX_SEP_PARSE_MTC_WRAP_BUFF_t			MtcBuff;/*0x100*/
	DX_SEP_PARSE_PRIVATE_KEY_BUFF_t			privKeyBuff;/*0x87c*/
	DX_SEP_PARSE_CA_KG_CONTEXT_t			caKgBuff;/*0x1274*/
	DxUint32_t								rawBuff[1000];/*0xFA0*/
#ifdef KMNG_ON_SEP
	DX_SEP_PARSE_USER_KEY_KMNG_BUFF_t		kmngUserKey;/*0x129c*/
	DX_SEP_PARSE_KMNG_RSA_KEY_t				kmngRsaKey;
#endif
#ifdef SST_ON_SEP
    DX_SEP_PARSE_CRYS_SST_RSA_BUFF_t        crysSstBuffer;   /* 4552 bytes */
#endif
#ifdef TLK_ODRM_ON_SEP
    DX_SEP_PARSE_TLK_ODRM_LLF_t             tlkOdrmBuffer;
#endif  
#ifdef TLK_CERT_ON_SEP
    TLK_CERT_RESPONSE_PROCESS_BUFF_t        tlkCertResponseProcessBuff;
#endif
}DX_SEP_PARSE_GLOBAL_CONTEXT_t;

/************************ Public Variables **********************/

/************************ Public Functions **********************/

#ifdef __cplusplus
}
#endif

#endif /*GLOBAL_CONTEXT_H*/
